create or replace package tbicds.PCK_CPA
AUTHID CURRENT_USER 
is

/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

   --type defs to return recordsets
  type RetRefCursor is ref cursor;
  type refCursor is ref cursor;

/****
insert a new pat pw event
***/
procedure InsertPatPWEvent (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      
      pi_nRegionID              in number,
      pi_nSiteID                in number,
    
      pi_vPatientID             in varchar2,
      pi_nPatPWID               in number,
   
      pi_vEventTitle            in varchar2,
      pi_dtEventDate            in date,
      pi_nAdjustFuture          in number,
      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      );
      
/******
delete an event
******/  
procedure DeleteEvent (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nPatPWEventID          in number,
    
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      );
      

/******
Check if the user can delete the event
******/  
procedure AllowEventDelete (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nPatPWEventID          in number,
         
      po_nAllowDelete           out number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      );
      
/***
Update the pw event info
****/
procedure UpdatePatPWEvent (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nPatPWEventID          in number,
      
      pi_vEventTitle            in varchar2,
      pi_dtEventDate            in date,
      pi_nAdjustFuture          in number,
      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      );
      
/*delete a scheduled module*/
procedure DeletePatPWEventModules (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      
      pi_vPatientID             in varchar2,
      pi_nPatPWEventID          in number,
      pi_vMIDS                  in varchar2,
     
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      );


/*****
Gets all pathway event modules associated 
with a specific patient pathway event
******/
procedure GetPWEventModuleRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nPatPWEventID             in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      );
      
/***
insert modules into the pat pw event module list
****/
procedure InsertPatPWEventModules (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      
      pi_vPatientID             in varchar2,
      pi_nPatPWEventID          in number,
      pi_vMIDS                  in varchar2,
      pi_vModuleFors            in varchar2,
     
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      );
      
/*****
Gets all clinical program area types
******/
procedure GetCPATypeRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      );

/*****
Gets all clinical program areas by region/site
******/
procedure GetCPARS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_nRegionID              in number,
      pi_nSiteID                in number,
 
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      );
      
/*****
Gets all pathways for a clinical program area
******/      
procedure GetCPAPWRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_nCPAID                 in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      );

/*****
Gets all pathway events for a pathway
******/
procedure GetPWEventRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_nPWID                  in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      );
      
/*****
Gets all modules for a pathway event
******/
procedure GetPWEventModuleRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_nPWID                  in number,
      pi_nPWEventID             in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor  
      );


/*****
Gets all events and modules for a pathway 
******/
procedure GetPWEventAndModuleRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_nPWID                  in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      );
      
----USER tables----------------------------------------------------

/*****
update a users default clinical program area
******/
procedure UpdateUserDefaultCPA (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_nCPAID                 in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      );
                       
/*****
Gets a users clinical program areas
******/
procedure GetUserCPARS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      );

----PATIENT tables-------------------------------------------------


/*****
Gets ALL pathways associated with a patient, 
ordered by clinical program area
******/
procedure GetPatPWRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      );


/*****
Check if the Event is Read-Only
******/
procedure IsPatPWEventReadOnly (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nPatPWID               in number,
      pi_nPatPWEventID          in number,
      po_nIsReadOnly            out number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      );
      
/*****
Gets all pathway events for a specific patient pathway
******/
procedure GetPatPWEventRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nPatPWID                  in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      );
      
/*****
Gets all pathway events associated with a patient
******/
procedure GetPatPWEventRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      );
      
/*****
Gets one pathway event associated with a patient
******/
procedure GetPatPWEventRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nPatPWEventID          in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      );
      
/*****
Gets all pathway event modules associated 
with a specific patient pathway event
******/
procedure GetPatPWEventModuleRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nPatPWID               in number,
      pi_nPatPWEventID             in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      );

/*****
Gets all pathway event modules associated with a patient 
******/
procedure GetPatPWEventModuleRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      );
       
/*get all modules for a patient pw event*/
procedure GetPatPWEventModuleRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nPatPWEventID             in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      );
      
----------operations---------------

/*****
Updates Patient Event Module status after a module is completed
*****/
procedure UpdatePatPWEventModule (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nPWID                  in number,
      pi_nPatPWEvtID            in number,
      pi_nMID                   in number,
      pi_nIntakeID              in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      ); 
      
procedure UpdatePatPWEventModule (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nPWID                  in number,
      pi_nPatPWEvtID            in number,
      pi_nMID                   in number,
      pi_nIntakeID              in number,
      pi_nPwEvtModID              in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      );     
            
/******
apply a pathway/schedule to a patient
******/      
procedure ApplyPathway (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      
      pi_vPWIDs                 in varchar2,
      pi_vPWTitle               in varchar2,
      pi_dtBaseline             in date,
      
      po_nPatPWID               out number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      );
            
procedure ApplyDefaultPathway (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      
      pi_vPatientID             in varchar2,
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      );

procedure InsertPatPWEventModules (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nPatPWEventID          in number,
      pi_vMIDS                  in varchar2,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      );
      
procedure UpdatePatPWEventModules (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nPatPWEventID          in number,
      
      pi_vEventTitle            in varchar2,
      pi_dtEventDate            in date,
      pi_nAdjustFuture          in number,
 
      pi_vMIDS                  in varchar2,
      pi_vModuleFors            in varchar2,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      );
  
            
end PCK_CPA;
/

